@extends('panel.layout.app')

@section('title', __('Team'))

@section('content')
    <!-- Page body -->
    <div class="py-10">
        <div class="flex flex-wrap gap-y-8">
            <div class="row">
                <div class="col-md-5 mx-auto">
                    <div class="header d-flex justify-content-center">
                        @if ($user && $user?->avatar)
                            <img
                                src="{{ custom_theme_url($user?->avatar) }}"
                                style="width: 150px"
                            >
                        @endif

                        <div class="w-full p-3">
                            <p class="fs-2 font-bold">{{ $user?->fullName() }}</p>
                            @if ($member->joined_at)
                                <p>@lang('Member Since') {{ $member->joined_at->format('M d, Y') }}</p>
                            @endif
                            <span
                                class="badge bg- bg-{{ $member->status == 'waiting' ? 'dark font-weight-medium' : ($member->status == 'active' ? 'success' : 'danger') }}">@lang(strtoupper($member->status))</span>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <p class="fs-1 font-bold">@lang('Your Team Plan')</p>
                            <p>@lang("You have the Team plan which has a remaining balance of <strong class='font-bold font-weight-medium'>:word</strong> words and <strong class='font-bold font-weight-medium'>:image</strong> images.", ['word' => $remaining_words, 'image' => $remaining_images]) </p>
                            <div class="relative">
                                <h3 class="absolute left-1/2 top-[calc(50%-5px)] m-0 -translate-x-1/2 text-center text-[14px] font-normal">
                                    <strong class="text-[2em] font-semibold leading-none max-sm:text-[1.5em]">
                                        @if ($remaining_words == -1)
                                            {{ __('Unlimited') }}
                                        @else
                                            @formatNumber($remaining_words)
                                        @endif
                                    </strong>
                                    <br>
                                    {{ __('Tokens') }}
                                </h3>
                                <div
                                    class="relative [&_.apexcharts-legend-text]:!m-0 [&_.apexcharts-legend-text]:!pe-2 [&_.apexcharts-legend-text]:ps-2"
                                    id="chart-credit"
                                >
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4 mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <label class="font-weight-medium mb-3">
                                        @lang('Words Generated') <x-info-tooltip text="{{ __('Displays the number of words generated by this team member.') }}" />
                                    </label>
                                    <span>{{ $remaining_words }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <label class="font-weight-medium mb-3">
                                        @lang('Images Generated') <x-info-tooltip text="{{ __('Displays the number of images generated by this team member.') }}" />
                                    </label>
                                    <span>{{ $remaining_images }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div
                        class="mb-4 rounded-xl p-3"
                        style="background-color: rgba(157, 107, 221, 0.1);"
                    >
                        <p class="fs-2 font-weight-medium mb-0 pb-0 font-bold"><span
                                class="me-2 rounded pe-2 ps-2 text-white"
                                style="background-color: rgba(157, 107, 221, 1)"
                            >1</span>@lang('Manage User')</p>
                    </div>

                    <form
                        class="row"
                        action="{{ route('dashboard.user.team.member.update', [$team->id, $member->id]) }}"
                        method="post"
                    >
                        @csrf
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label class="form-label">{{ __('Role') }}</label>
                                <input
                                    class="form-control @error('role') is-invalid @enderror"
                                    id="role"
                                    type="text"
                                    name="role"
                                    value="{{ $member->role }}"
                                >
                                @error('role')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-4">
                                <label class="form-label">{{ __('Status') }}</label>
                                <select
                                    class="form-control @error('role') is-invalid @enderror"
                                    name="status"
                                >
                                    <option
                                        value="active"
                                        {{ $member->status == 'active' ? 'selected' : '' }}
                                    >
                                        @lang('Active')</option>
                                    <option
                                        value="waiting"
                                        {{ $member->status == 'waiting' ? 'selected' : '' }}
                                    >
                                        @lang('Waiting')</option>
                                    <option
                                        value="cancelled"
                                        {{ $member->status == 'cancelled' ? 'selected' : '' }}
                                    >
                                        @lang('Cancelled')</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <label class="font-weight-medium mb-3">
                                @lang('Credits') <x-info-tooltip text="{{ __('Set unlimited or limited credits for this user.') }}" />
                            </label>
                            <div class="mb-4">
                                <label class="form-check form-switch d-flex justify-content-between">
                                    <span class="form-check-label me-4 ms-0 ps-0">Allow Unlimited Credits?</span>
                                    <input
                                        class="form-check-input"
                                        id="allow_unlimited_credits"
                                        type="checkbox"
                                        name="allow_unlimited_credits"
                                        {{ $member->allow_unlimited_credits ? 'checked' : '' }}
                                    >
                                </label>
                                <small>@lang('If allowed, user will be able to use all credits available in the team package.')</small>
                            </div>
                        </div>
                        <div
                            class="col-md-12 {{ old('allow_unlimited_credits', $member->allow_unlimited_credits) ? 'd-none' : '' }}"
                            id="credit_limit_custom"
                        >
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">
                                            {{ __('Image Credit Limit') }}
                                            <x-info-tooltip
                                                text="{{ __('Set a specific image credit limit for this user. This function works only if unlimited credits are disabled.') }}"
                                            />
                                        </label>
                                        <input
                                            class="form-control @error('remaining_images') is-invalid @enderror"
                                            id="remaining_images"
                                            type="text"
                                            name="remaining_images"
                                            value="{{ $member->remaining_images }}"
                                        >
                                        @error('remaining_images')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">
                                            {{ __('Word Credit Limit') }}
                                            <x-info-tooltip
                                                text="{{ __('Set a specific word credit limit for this user. This function works only if unlimited credits are disabled.') }}"
                                            />
                                        </label>
                                        <input
                                            class="form-control @error('remaining_words') is-invalid @enderror"
                                            id="remaining_words"
                                            type="text"
                                            name="remaining_words"
                                            value="{{ $member->remaining_words }}"
                                        >
                                        @error('remaining_words')
                                            <div class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <button
                                class="btn btn-primary w-full"
                                type="submit"
                            >
                                @lang('Save Changes')
                            </button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        // @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            "use strict";

            $('#allow_unlimited_credits').change(function() {

                let checked = $(this).is(':checked');

                if (checked) {
                    $('#credit_limit_custom').addClass('d-none');
                } else {
                    $('#credit_limit_custom').removeClass('d-none');
                }
            })

            const options = {
                series: [{{ (int) $remaining_words }}, {{ (int) $total_words }}],
                labels: [@json(__('Remaining')), @json(__('Used'))],
                colors: ['#9A34CD', 'rgba(154,52,205,0.2)'],
                chart: {
                    type: 'donut',
                    height: 205,
                },
                legend: {
                    position: 'bottom',
                    fontFamily: 'inherit',
                },
                plotOptions: {
                    pie: {
                        startAngle: -90,
                        endAngle: 90,
                        offsetY: 0,
                        donut: {
                            size: '75%',
                        }
                    },
                },
                grid: {
                    padding: {
                        bottom: -130
                    }
                },
                stroke: {
                    width: 5,
                    colors: 'hsl(var(--background))'
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 280,
                            height: 250
                        },
                    }
                }],
                dataLabels: {
                    enabled: false,
                }
            };
            window.ApexCharts && (new ApexCharts(document.getElementById('chart-credit'), options)).render();
        });
        // @formatter:on
    </script>
@endpush
